<!DOCTYPE html>
<html lang="en" style="height: 100%;">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="x-ua-compatible" content="ie=edge">

    <title>Tracking Result</title>

    <!-- Favicon -->
    <link href="{{ asset('storage/app/public/'.$settings->favicon)}}" rel="shortcut icon">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Libre Barcode 128 Text" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Open+Sans&display=swap" rel="stylesheet">

    <!-- CSS Libraries -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://use.fontawesome.com/releases/v5.7.2/css/all.css" rel="stylesheet">
    <link href="http://maxcdn.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css" rel="stylesheet">
    <link rel="stylesheet" href="temp/custom/re/result_files/owl.carousel.css">
    <link rel="stylesheet" href="temp/custom/re/result_files/owl.theme.css">
    <link rel="stylesheet" href="temp/custom/re/result_files/cm-overlay.css">
    <link rel="stylesheet" href="temp/custom/re/result_files/magnific-popup.css">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="temp/custom/re/result_files/style.css">
    <link rel="stylesheet" href="temp/custom/re/result_files/style2.css">

    <!-- JavaScript Libraries -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.bundle.min.js"></script>
    <script src="temp/custom/re/result_files/jquery-1.11.1.min.js"></script>
    <script src="temp/custom/re/result_files/bootstrap.js"></script>
    <script src="temp/custom/re/result_files/html5shiv.min.js"></script>
    <script src="temp/custom/re/result_files/respond.min.js"></script>

    <!-- Google Translate -->
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>


 <style>@import url('https://fonts.googleapis.com/css?family=Open+Sans&display=swap');

body {
    background-color: #eeeeee;
    font-family: 'Open Sans', serif
}

body2 {
    font-family: 'Libre Barcode 128 Text';font-size: 22px;
}

.container {
    margin-top: 50px;
    margin-bottom: 50px
}

.col {

    margin-bottom: 20px
}

.card {
    position: relative;
    display: -webkit-box;
    display: -ms-flexbox;
    display: flex;
    -webkit-box-orient: vertical;
    -webkit-box-direction: normal;
    -ms-flex-direction: column;
    flex-direction: column;
    min-width: 0;
    word-wrap: break-word;
    background-color: #fff;
    background-clip: border-box;
    border: 1px solid rgba(0, 0, 0, 0.1);
    border-radius: 0.10rem
}

.card-header:first-child {
    border-radius: calc(0.37rem - 1px) calc(0.37rem - 1px) 0 0
}

.card-header {
    padding: 0.75rem 1.25rem;
    margin-bottom: 0;
    background-color: #fff;
    border-bottom: 1px solid rgba(0, 0, 0, 0.1)
}

.track {
    position: relative;
    background-color: #ddd;
    height: 7px;
    display: -webkit-box;
    display: -ms-flexbox;
    display: flex;
    margin-bottom: 60px;
    margin-top: 50px
}

.track .step {
    -webkit-box-flex: 1;
    -ms-flex-positive: 1;
    flex-grow: 1;
    width: 25%;
    margin-top: -18px;
    text-align: center;
    position: relative

}

.track .step.active:before {
    background: #0069a3
}

.track .step::before {
    height: 7px;
    position: absolute;
    content: "";
    width: 100%;
    left: 0;
    top: 18px
}

.track .step.active .icon {
    background: #0069a3;
    color: #fff
}

.track .icon {
    display: inline-block;
    width: 40px;
    height: 40px;
    line-height: 40px;
    position: relative;
    border-radius: 100%;
    background: #ddd
}

.track .step.active .text {
    font-weight: 400;
    color: #000
    font-size: 30px;
}

.track .text {
    display: block;
    margin-top: 7px

}

.itemside {
    position: relative;
    display: -webkit-box;
    display: -ms-flexbox;
    display: flex;
    width: 100%
}

.itemside .aside {
    position: relative;
    -ms-flex-negative: 0;
    flex-shrink: 0
}

.img-sm {
    width: 270px;

    padding: 7px
}

ul.row,
ul.row-sm {
    list-style: none;
    padding: 0
}

.itemside .info {
    padding-left: 15px;
    padding-right: 7px
}

.itemside .title {
    display: block;
    margin-bottom: 5px;
    color: #212529
}

p {
    margin-top: 0;
    margin-bottom: 1rem
}

.btn-warning {
    color: #ffffff;
    background-color: #0069a3;
    border-color: #0069a3;
    border-radius: 1px
}

.btn-warning:hover {
    color: #ffffff;
    background-color: #ff2b00;
    border-color: #ff2b00;
    border-radius: 1px
}
</style>

<script type="text/javascript">
function googleTranslateElementInit() {
  new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element');
}
function nokApply(){
	window.location='next-of-kin.php';
}
</script>
</head>



<body style="position: relative; min-height: 100%; top: 0px;">

	<!-- banner -->
	<div class="banner " id="home">
		<!-- menu -->

<script type="text/javascript">
                    $(document).ready(function(){
                      setTimeout(function(){
                        $("#tracking-loading").fadeOut();
                        $("#tracking-result").fadeIn();
                      },1000); });
                </script>






 <div class="container"><div class="card">
  <div id="tracking-loading" style="text-align: center; padding: 30px 2px; display: none;">
<img src="temp/custom/re/img/ajax-loader.gif" alt="Loading results...">
<h4 style="">
Fetching Result for Tracking Number: {{ $courier->trackingnumber }}...
</h4>
</div></div>

 <article id="tracking-result" style="" class="card">
        <header class="card-header">
         <div class="card-body row">
                    <div class="col"> My Orders / Tracking <br> <a align="right" href="/">Back to Home</a>  </div>
                    <div class="col">   </div>

                    <div class="col">  </div>

                    <div class="col">    <body2><h1>{{ $courier->trackingnumber }}</h1>  </body2>   </div>
                </div>



         </header>
        <div class="card-body">
            <h6>Order ID: {{ $courier->trackingnumber }} </h6>
            <article class="card">
                <div class="card-body row">
                    <div class="col"> <strong>Sender Information:</strong>
                    <br> 	<span class="text-muted"> Name:</span> {{$courier->sname}} <br>
					<span class="text-muted">	 Address:</span>  {{$courier->saddress}} </div>
                    <div class="col"> <strong>Receiver Information:</strong> <br> <i class="fa fa-user"></i> {{$courier->name}} <br> <i class="fa fa-phone"></i> {{$courier->phone}}  </div>

                    <div class="col"> <strong>Destination Address:</strong> <br> <i class="fa fa-map-marker"></i> {{$courier->address}} <br><i class="fa fa-envelope"></i> {{$courier->email}}</div>

                    <div class="col"> <strong>Status</strong> <img alt="" src="temp/custom/re/result_files/icon.gif" height="15" width="15"><br> {{$courier->status}} </div>
                </div>

               </article>


              <div class="track">
                        <div class="step active">
                            <span class="icon"><i class="fa fa-check"></i></span>
                            <span class="text">Order confirmed</span>
                        </div>

                        @php
    // Check if any track has a specific status
    $hasPickedByCourier = $tracks->contains('status', 'Picked by Courier');
    $hasOnTheWay = $tracks->contains('status', 'On The Way');
    $hasCustomHold = $tracks->contains('status', 'Custom Hold');
    $hasDelivered = $tracks->contains('status', 'Delivered');
@endphp

<div class="step {{ $hasPickedByCourier ? 'active' : '' }}">
    <span class="icon"><i class="fa fa-user"></i></span>
    <span class="text">Picked by Courier</span>
</div>

<div class="step {{ $hasOnTheWay ? 'active' : '' }}">
    <span class="icon"><i class="fa fa-truck"></i></span>
    <span class="text">On The Way</span>
</div>

<div class="step {{ $hasCustomHold ? 'active' : '' }}">
    <span class="icon"><i class="fa fa-exclamation-triangle"></i></span>
    <span class="text">Custom Hold</span>
</div>

<div class="step {{ $hasDelivered ? 'active' : '' }}">
    <span class="icon"><i class="fa fa-cubes"></i></span>
    <span class="text">Delivered</span>
</div>
                    </div>


            <br><br>
            <hr>
       <ul class="row list-unstyled g-4">
    <!-- Parcel Info Card -->
   <li class="col-12 col-md-7">
    <div class="card h-100">
        <div class="card-body">
            <figure class="d-flex flex-column flex-lg-row">
                @if($courier->photo)
                <div class="text-center mb-3 mb-lg-0 me-lg-3" style="flex-shrink: 0; max-width: 240px; width: 100%;">
                    <img src="{{ asset('storage/app/public/photos/' . $courier->photo) }}"
                         class="img-thumbnail img-fluid"
                         style="max-width: 100%; height: auto; max-height: 280px;"
                         alt="Parcel photo">
                </div>
                @endif

                <figcaption class="flex-grow-1">
                    <h5 class="card-title border-bottom pb-2 mb-3 text-primary">Parcel Information</h5>
                    <dl class="row mb-0">
                        <dt class="col-sm-6 col-md-5 col-lg-4 text-muted">Duty Fees:</dt>
                        <dd class="col-sm-6 col-md-7 col-lg-8 text-success fw-bold">Paid</dd>

                        <dt class="col-sm-6 col-md-5 col-lg-4 text-muted">Weight:</dt>
                        <dd class="col-sm-6 col-md-7 col-lg-8">{{ $courier->weight }} kg</dd>

                        <dt class="col-sm-6 col-md-5 col-lg-4 text-muted">Pickup Date/Time:</dt>
                        <dd class="col-sm-6 col-md-7 col-lg-8">{{ \Carbon\Carbon::parse($courier->date_shipped)->toDayDateTimeString() }}</dd>

                        <dt class="col-sm-6 col-md-5 col-lg-4 text-muted">Date of Departure:</dt>
                        <dd class="col-sm-6 col-md-7 col-lg-8">{{ \Carbon\Carbon::parse($courier->expected_delivery)->toDayDateTimeString() }}</dd>

                        <dt class="col-sm-6 col-md-5 col-lg-4 text-muted">Delivery Mode:</dt>
                        <dd class="col-sm-6 col-md-7 col-lg-8">{{ $courier->freight_type }}</dd>
                    </dl>
                </figcaption>
            </figure>
        </div>
    </div>
</li>

<!-- Shipment History Card -->
<li class="col-12 col-md-5">
    <div class="card h-100">
        <div class="card-body">
            <h5 class="card-title text-primary mb-3">Shipment History</h5>
            <hr class="mt-0">

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th class="text-primary">DATE</th>
                            <th class="text-primary">DELIVERY STATUS</th>
                            <th class="text-primary">COUNTRY</th>
                            <th class="text-primary">COMMENT</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($tracks as $track)
                        <tr>
                            <td>{{ \Carbon\Carbon::parse($track->created_at)->toDayDateTimeString() }}</td>
                            <td><span class="badge bg-info text-dark">{{ $track->status }}</span></td>
                            <td>{{ $track->city }}</td>
                            <td>{{ $track->comment }}</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="text-center text-muted py-3">No shipment history available</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</li>

<style>
    /* Responsive table for small screens */
    @media (max-width: 767.98px) {
        .table-responsive table {
            width: 100%;
        }
        .table-responsive thead {
            display: none;
        }
        .table-responsive tr {
            display: block;
            margin-bottom: 1rem;
            border: 1px solid #dee2e6;
        }
        .table-responsive td {
            display: flex;
            justify-content: space-between;
            padding: 0.75rem;
            text-align: right;
            border-bottom: 1px solid #dee2e6;
        }
        .table-responsive td::before {
            content: attr(data-label);
            font-weight: bold;
            margin-right: 1rem;
            color: #6c757d;
        }
        .table-responsive td:last-child {
            border-bottom: 0;
        }
    }
</style>
            <hr> <a onclick="" href="{{ route('printnow', $courier->id) }}" class="btn btn-warning"> <i class="fa fa-print"></i> Print Tracking</a>





        </div>


       <div style="width: 100%; max-width: 1100px; margin: 0 auto;">
  <div style="position: relative; padding-bottom: 36%; height: 0; overflow: hidden;">
    <iframe
      style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;"
      frameborder="0"
      scrolling="no"
      marginheight="0"
      marginwidth="0"
      id="gmap_canvas"
      src="https://maps.google.com/maps?width=1126&amp;height=397&amp;hl=en&amp;q={{ $courier->location }}+(Tracking%20map)&amp;t=p&amp;z=12&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"
      allowfullscreen>
    </iframe>
  </div>
  <div style="text-align: right; font-size: 12px;">
    <a href='https://maps-generator.com/'>Maps Generator</a>
  </div>
</div>
    </article>












<script>
function googleTranslateElementInit() {
new google.translate.TranslateElement({
pageLanguage: 'da',
includedLanguages: 'da,pt,ar,pl,fr,es,it,en,ko,zh-CN',
layout: google.translate.TranslateElement.InlineLayout.SIMPLE
}, 'google_translate_element');
}
</script><script src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
<div id="google_translate_element"></div>

<style type="text/css">
        /* OVERRIDE GOOGLE TRANSLATE WIDGET CSS BEGIN */
       .goog-te-menu-value {
                                    padding: 3px !important;
                                }

                                .goog-te-gadget-simple {
                                    background-color: #fff;
                                    border-left: 1px solid #d5d5d5;
                                    border-top: 1px solid #9b9b9b;
                                    border-bottom: 1px solid #e8e8e8;
                                    border-right: 1px solid #d5d5d5;
                                    font-size: 10pt;
                                    display: inline-block;
                                    padding-top: 1px;
                                    padding-bottom: 2px;
                                    border-radius: 10px;
                                    cursor: pointer;
                                    zoom: 1;
                                }

        div#google_translate_element div.goog-te-gadget-simple a.goog-te-menu-value:hover {
            text-decoration: none;
        }

        div#google_translate_element div.goog-te-gadget-simple a.goog-te-menu-value span {
            color: blue;
        }

        div#google_translate_element div.goog-te-gadget-simple a.goog-te-menu-value span:hover {
            color: blue;
        }




        div#google_translate_element div.goog-te-gadget-simple a.goog-te-menu-value span[style="border-left-color: rgb(187, 187, 187); border-left-width: 1px; border-left-style: solid;"] {
            display: none;
        }
        /* HIDE the google translate toolbar */
        .goog-te-banner-frame.skiptranslate {
            display: none !important;
        }
        body {
            top: 0px !important;
        }
        .skiptranslate iframe  {
visibility: hidden !important;
    }
body{
    top:0!important;

}
        /* OVERRIDE GOOGLE TRANSLATE WIDGET CSS END */
    </style>
    <!-- Google Translate Element end -->
	</div>
	<!-- //banner -->

	<!-- copyright -->


</div>
</body>
</html>

